public class AttackAction : IAction
{
    private Character _character;
    private readonly IAttack _attack;
    private readonly Character _target;
    public AttackAction(Character character, IAttack attack, Character target)
    {
        _character = character;
        _attack = attack;
        _target = target; 
    }
    
    //run the action
    public void Execute()
    {
        AttackData attackData = _attack.GenerateAttackData();
        _target.TakeDamage(attackData.Damage);


        ConsolePlus.WriteLine($"{_character.Name} used {_attack.Name} on {_target.Name}", ConsoleColor.Yellow);
        if (attackData.Damage == 0)
        {
            ConsolePlus.WriteLine("Attack missed!", ConsoleColor.DarkGray);
        }
        
        ConsolePlus.WriteLine($"{_attack.Name} did {attackData.Damage} damage!",ConsoleColor.Red);
        Console.WriteLine("");
        Thread.Sleep(500);
        if (_attack.Name== "FORGETFUL SPELL" && attackData.Damage> 0)
        {
            Console.ForegroundColor = ConsoleColor.DarkYellow;
            Console.WriteLine($"AHH Forgetful Spell is making my C# a little less sharp.");
        }
        
        ConsolePlus.WriteLine($"{_target.Name} has { _target.CurrentHealth}/{_target.MaxHealth} HP.", ConsoleColor.DarkGreen);
        
        if (_target.CurrentHealth <= 0)
        {
            ConsolePlus.WriteLine($"{_target.Name} has been defeated!", ConsoleColor.Green);
        }
    }
}

public interface IAction { void Execute(); }

// rest (regain hp)
public class RestAction : IAction
{
    private readonly Character _character;

    public RestAction(Character currentExecutor)
    {
        _character = currentExecutor;
        if (_character.CurrentHealth< _character.MaxHealth)
            _character.Heal(2);
        
    }
    //run the action
    public void Execute()
    {
        Console.ForegroundColor = ConsoleColor.White;
        Console.WriteLine($"{_character.Name} RESTED.");
        Console.ForegroundColor = ConsoleColor.Green;
        Console.WriteLine($"Health is now: {_character.CurrentHealth}/{_character.MaxHealth} HP.");
    }
}

